<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');


include('../functions.php');

if (isset($_POST['set_payment']) && $_POST['set_payment'] != '') {
    $set_payment = $_POST['set_payment'];
    $client_id = $_POST['set_client_id'];
    $cart_id = $_POST['cart_id'];
    $client_address_id = $_POST['set_client_address_id'];

    $get_order_price = orderPrice($cart_id);

    $setting = setting(); //to get vat and discount
    $discount_percentage = $setting['discount'] ? $setting['discount_percentage'] : 0;

    $discount_percentage_amount = (($discount_percentage / 100) * $get_order_price);
    $region_id = get_user_address()['region']; //get region id to get fees of delivery
    $get_charge = get_region_data($region_id)["charge"]; //delivery Fees

    $net_price = number_format((float) ($get_order_price - $discount_percentage_amount), 3, '.', '');

    $vat = get_vat();
    $vat_added = (($vat / 100) * $net_price);
    $net_price_after_vat = number_format((float) ($net_price + $vat_added + $get_charge), 3, '.', '');

    $response["success"] = "1";
    $response["order_price"] = $net_price_after_vat;

    echo json_encode($response);

    die();
}