<?php
include ('functions.php');
include ('header.php');

$accept_order = $setting['accept_orders'];
$item_in_cart = get_item_count();
if (!$item_in_cart || !$accept_order) {
    header("Location: index.php");
    exit();
}

if (!isset($_POST['confirm_order'])) {
    header("Location: index.php");
    exit();
} else {

    $name = $_POST['name'];
    $phone = $_POST['phone'];
    $region_id = $_POST['region_id'];
    $buidling = $_POST['buidling'];
    $road = $_POST['road'];
    $block = $_POST['block'];
    $email = $_POST['email'];
    $order_type = $_POST['order_type']; //delivery Or Take Away
    $special_directions = $_POST['special_directions'];


    $add_address = add_user_address($name, $phone, $region_id, $buidling, $road, $block, $special_directions, $email, $order_type);
  
    $_SESSION['user_address_id'] = $add_address;

    if (!$add_address) {
        echo mysqli_error($con);
        exit;
        header("Location: index.php");
        exit();
    }
}


$main_data = mainData(); // array one raw
$parent_categories = parentCategory(); // array many row
$address_data = get_user_address();
$region_id = $address_data['region'];
$charge_cost = get_region_data($region_id)["charge"];
$min_order = get_region_data($region_id)["min_order"];
if ($order_type == "TakeAway") {
    $min_order = 0;
}
$setting = setting();
?>

<style>
    /* Edit Image of Logo and bg Area */
    //.top-header .logo-area .logo { background-image: url(<?php echo $main_data['image']; ?>); }
    .bg-area{
        background-image: url(<?php echo $main_data['image_backGround']; ?>);
    }
</style>

<div class="row branches pt-5">

    <div class="container py-3 px-0">
        <div class="row" id="checkout-confirm-finish">

            <div class="col-12 col-sm-4 my-2">
                <div class="border border-border-Aluminium p-3 w-100">
                    <h4 class="h5 text-capitalize"><span data-icon="&#xf0a2" class="px-2 d-inline-block"></span> <?php echo $order_summary; ?> </h4>
                    <?php
                    $cart = get_item_cart()["data"];
                    $vat = $setting['vat']; //vat percentage
                    $discount = $setting['discount'] ? $setting['discount_percentage'] : 0; //disocunt percentage

                    $sum_total = 0;
                    $order_summary = "";
                    $all_cart_ids = '';
                    foreach ($cart as $key => $row) {
                        $id = $row['cart_id'];
                        $sub_catgeory_id = $row['sub_catgeory_id'];
                        $sub_category_name = $row['sub_category_name'];
                        $price = $row['price'];
                        $notes = $row['notes'];
                        $quantity = $row['quantity'];
                        $status = $row['status'];
                        $user_id = $row['client_id'];
                        $date_added = $row['date_added'];
                        $total_price = number_format($row['price'], 3, '.', '');
                        $sum_total += number_format($total_price, 3, '.', '');
                        $all_cart_ids .= $id . ',';

                        $order_summary .= '<p class="py-3 m-0 font-weight-bold text-capitalize ">' . $quantity . 'x ' . $sub_category_name . '<span class="float-right">' . $total_price . ' ' . $currency_name . ' </span></p>';
                    }
                    $all_cart_ids = substr($all_cart_ids, 0, -1);
                    $discount_value = number_format($discount / 100 * $sum_total, '3', '.', '');
                    $vat_value = number_format($vat / 100 * ($sum_total - $discount_value), '3', '.', '');

                    $sub_total = number_format(($sum_total), 3, '.', '');
                    $sum_total = number_format(($sum_total + $vat_value - $discount_value + $charge_cost), 3, '.', '');
                    if ($discount > 0) {
                        $draw_div = '<p class="py-3 m-0 font-weight-bold text-secondary text-capitalize ">' . $discount_name . '(' . $discount . '%) <span class="float-right">' . $discount_value . ' ' . $currency_name . ' </span></p>';
                    }

                    $order_summary .= '  <p class="py-3 m-0 font-weight-bold text-secondary text-capitalize ">' . $sub_total_name . '<span class="float-right">' . $sub_total . ' ' . $currency_name . ' </span></p>
                                         ' . $draw_div . '
                                          <p class="py-3 m-0 font-weight-bold text-secondary text-capitalize "> ' . $vat_name . ' (' . $vat . '%) <span class="float-right">' . $vat_value . ' ' . $currency_name . ' </span></p>';

                    if ($order_type == "Delivery") {

                        $order_summary .= '<p class="py-3 m-0 font-weight-bold text-secondary text-capitalize " >' . $delivery_fee_name . ' <span class="float-right" id="delivery-fee" >' . $charge_cost . ' ' . $currency_name . ' </span></p>';
                    }
                    $order_summary .= '<p class="py-3 m-0 font-weight-bold text-capitalize ">' . $total_name . ' <span id="cart-total-span" class="float-right">' . $sum_total . ' ' . $currency_name . ' </span></p>';

                    echo $order_summary;
                    ?>
                </div>
            </div>


            <input type="hidden" name="all_cart_ids" id=all_cart_ids value="<?php echo $all_cart_ids; ?>">
            <input type="hidden" name="client_address_id" id=client_address_id value="<?php echo $address_data['id']; ?>">
            <input type="hidden" name="set_client_id" id=set_client_id value="<?php echo $_SESSION['one_user_id']; ?>">
            <input type="hidden" name="site_url" id=site_url value="<?php echo $site_url; ?>">
            <input type="hidden" name="region_name_selected" id=region_name_selected value="<?php echo get_user_address()['region_name_en']; ?>">



            <div class="col-12 col-sm-8 px-3 px-sm-0 my-2">


                <div class="border border-border-Aluminium mb-3 row px-0 py-2">
                    <h4 class="h5 text-capitalize col-12 px-2"><span data-icon="&#xf2c7" class="px-2 d-inline-block"></span><?php echo $contact_info_name; ?></h4>
                    <div class="col-12 col-sm-6">
                        <p >
                            <strong class="d-block w-10 text-uppercase"><?php echo $name_title; ?></strong>
                            <?php echo $address_data['name']; ?>
                        </p>
                        <p >
                            <strong class="d-block w-10 text-uppercase"><?php echo $email_title; ?> </strong>
                            <?php echo $address_data['email']; ?>
                        </p>
                        <?php if ($order_type == "Delivery") { ?>

                            <p>
                                <strong class="d-block w-10 text-uppercase"><?php echo $address; ?></strong>
                                <?php echo $address_data['building'] . "," . $address_data['region_name_en'] . "," . $address_data['road'] . "," . $address_data['block'] . "," . $address_data['note']; ?>
                            </p>
                        <?php } ?>
                        <p>
                            <strong class="d-block w-10 text-uppercase"><?php echo $deliver_time; ?> </strong>
                            <?php echo date("Y-m-d H:i:s"); ?>
                        </p>
                    </div>
                    <div class="col-12 col-sm-6 ">
                        <p>
                            <strong class="d-block w-10 text-uppercase"><?php echo $phone_title; ?></strong>
                            <?php echo $address_data['phone']; ?>
                        </p>
                    </div>

                </div>

                <div class="border border-border-Aluminium mb-3 row py-2 overflow-hidden position-relative">
                    <h4 class="h5 text-capitalize col-12"><?php echo $payment ?></h4>

                    <?php
                    $payment_methods = paymentMethods();
                    foreach ($payment_methods as $row) {
                        $id = $row['id'];
                        $name = $row['name'];
                        $div .= "
                                
                                <div class='custom-control custom-radio custom-control-inline pl-5'>
                                    <input type='radio'  id='customRadioInline{$id}' checked value='{$id}' name='payment' class='form-control custom-control-input'>
                                    <label class='custom-control-label font-weight-bold' for='customRadioInline{$id}'>&nbsp; $name </label>
                                </div>
                    
                        ";
                    }

                    echo $div;
                    ?>





                    <!--<div class="custom-control custom-radio custom-control-inline pl-5">-->

                    <!--    <input type="radio" required id="customRadioInline2"  value="2" name="payment" class="form-control custom-control-input">-->
                    <!--    <label class="custom-control-label font-weight-bold" for="customRadioInline2">&nbsp;<?php echo $debit; ?></label>-->

                    <!--</div>-->

                    <!--<div class="custom-control custom-radio custom-control-inline pl-5">-->
                        <!--<input type="radio" required id="customRadioInline3"  value="3" name="payment" class="form-control custom-control-input">-->
                        <!--<label class="custom-control-label font-weight-bold" for="customRadioInline3">&nbsp;<?php echo $credit; ?></label>-->

                    <!--</div>-->
                    <div class="col-12 my-3">
                        <input type="submit" value="<?php echo $place_order; ?>" onclick="check_order_payment(<?php echo $min_order; ?>)" name="finish_order" class="btn btn-danger btn-block text-uppercase"  />
                        <!-- <a href="#" onclick="finish_order_confirm()" class="btn btn-danger btn-block text-uppercase m-3" type="submit">place order</a> -->
                    </div>

                </div>



            </div>

        </div>
    </div>

</div>

<?php include ('footer.php'); ?>