<?php

date_default_timezone_set('Asia/Bahrain');
//disable Errors
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);

//start Session
ob_start();
session_start();
ini_set('session.gc_maxlifetime', 60);

//database Connection
include ('connection.php');
include ('notification.php');


$main_image = mainData()['image'];

//check path if found 
function remoteFileExists($url) {
    $curl = curl_init($url);
    //don't fetch the actual page, you only want to check the connection is ok
    curl_setopt($curl, CURLOPT_NOBODY, true);
    //do request
    $result = curl_exec($curl);
    $ret = false;
    //if request did not fail
    if ($result !== false) {
        //if request was ok, check response code
        $statusCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
        if ($statusCode == 200) {
            $ret = true;
        }
    }

    curl_close($curl);

    return $ret;
}

// main data of Resturant
function mainData() {
    global $con;
    $query = $con->query("SELECT * FROM `about` LIMIT 1");
    $data = mysqli_fetch_assoc($query);
    if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
        $data["title_en"] = $data["title"];
        $data['content_en'] = $data['content'];
    }
    return $data;
}

//get setting of Website
function setting() {
    global $con;
    $query = $con->query("SELECT * FROM `setting` LIMIT 1");
    $data = mysqli_fetch_assoc($query);
    return $data;
}

//get Contact Data
function contact() {
    global $con;
    $query = $con->query("SELECT * FROM `contact` LIMIT 1");
    $data = mysqli_fetch_assoc($query);
    return $data;
}

//get parent catgeories
function parentCategory() {
    global $con;
    $query = $con->query("SELECT * FROM `parent_categories` WHERE `display`=1 order by 	arrangement");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
            $row["parent_category_name"] = $row["parent_category_name_ar"];
        }
        $id = $row['parent_category_id'];
        $row['subCategories'] = subCatgeoryByParentCatgeoryId($id);
        $data[] = $row;
    }
    return $data;
}

function paymentMethods() {
    global $con;
    $query = $con->query("SELECT * FROM `payment_methods` WHERE `display`=1 ");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
            $row["name"] = $row["name_ar"];
        } else {
            $row["name"] = $row["name_en"];
        }

        $data[] = $row;
    }
    return $data;
}


function paymentMethodDataById($id) {
    global $con;
    $query = $con->query("SELECT * FROM `payment_methods` WHERE `id`='$id' ");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        $data = $row;
    }
    return $data;
}


function get_region_id($client_id, $client_address_id) {
    global $con;
    include("connection.php");

    $result = $con->query("SELECT * FROM `user_addresses_session` WHERE `id`='$client_address_id' and `user_id`='$client_id' ORDER BY `id` DESC") or die(mysql_error());

    $row = mysqli_fetch_array($result);

    $region = $row['region'];

    return $region;
}

function get_charge($region_id) {
    global $con;

    $result = $con->query("SELECT * FROM `regions` WHERE `region_id`='$region_id'  ORDER BY `region_id` DESC") or die(mysqli_error());

    $row = mysqli_fetch_array($result);

    $charge = $row['charge'];

    return $charge;
}

function get_vat() {
    global $con;
    include("connection.php");

    $result = $con->query("SELECT * FROM `setting` WHERE `id`='1' ");

    $row = mysqli_fetch_array($result);

    $vat = $row['vat'];

    return $vat;
}

function orderPrice($cart_id) {

    global $con;
    include("connection.php");

    $carts_array = explode(",", $cart_id);
    $price = 0;
    foreach ($carts_array as $one_cart) {
        $query_select = $con->query("SELECT * FROM `cart` WHERE `cart_id`='" . $one_cart . "' ORDER BY `cart_id` LIMIT 1");
        $row_select = mysqli_fetch_array($query_select);
        $price += $row_select['price'];
    }
    return $price;
}

//get Sub Catgeories By Parent Id
function subCatgeoryByParentCatgeoryId($id) {
    global $con;
    $query = $con->query("SELECT * FROM `sub_categories` WHERE `parent_category_id`='$id' AND `display`=1  ");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
            $row["sub_category_name"] = $row["sub_category_name_ar"];
            $row["sub_category_desc"] = $row["sub_category_desc_ar"];
        }
        global $main_image;
        $row['sub_category_image'] = remoteFileExists($row['sub_category_image']) ? $row['sub_category_image'] : $main_image;

        $sub_category_id = $row['sub_category_id'];
        $row['sub_category_price'] = subCategorySizePrice($sub_category_id);
        $row['sizes'] = subCategorySizes($sub_category_id);

        $data[] = $row;
    }
    return $data;
}

// Get Sub Category By Id
function subCatgeoryById($id) {
    global $con;
    $query = $con->query("SELECT * FROM `sub_categories` WHERE `sub_category_id`='$id' LIMIT 1  ");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
            $row["sub_category_name"] = $row["sub_category_name_ar"];
            $row["sub_category_desc"] = $row["sub_category_desc_ar"];
        }

        global $main_image;
        $row['sub_category_image'] = remoteFileExists($row['sub_category_image']) ? $row['sub_category_image'] : $main_image;

        $sub_category_id = $row['sub_category_id'];

        $row['sub_category_price'] = subCategorySizePrice($sub_category_id);
        $row['additions'] = getAdditionBySubId($sub_category_id);
        $row['removes'] = getRemoveBySubId($sub_category_id);
        $row['sizes'] = subCategorySizes($sub_category_id);

        $data = $row;
    }
    return $data;
}

// search subCategory
function subCatgeoryBySeachKey($key) {
    global $con;
    $query = $con->query("SELECT * FROM `sub_categories` WHERE (`sub_category_name` LIKE '%$key%' OR `sub_category_name_ar` LIKE '%$key%' ) AND `display`=1 ");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
            $row["sub_category_name"] = $row["sub_category_name_ar"];
            $row["sub_category_desc"] = $row["sub_category_desc_ar"];
        }
        $sub_category_id = $row['sub_category_id'];
        global $main_image;
        $row['sub_category_image'] = remoteFileExists($row['sub_category_image']) ? $row['sub_category_image'] : $main_image;

        $row['sub_category_price'] = subCategorySizePrice($sub_category_id);
        $row['sizes'] = subCategorySizes($sub_category_id);

        $data[] = $row;
    }
    return $data;
}

//get additions by sub_id
function getAdditionBySubId($sub_category_id) {
    global $con;
    $query = $con->query("SELECT * FROM `sub_categories_addition_prices`  WHERE `sub_category_id`='$sub_category_id' ");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {

        if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
            $row["sub_category_addition_name"] = $row["sub_category_addition_name_ar"];
            // $row["sub_category_desc"]=$row["sub_category_desc_ar"];
        }
        $data[] = $row;
    }
    return $data;
}

function getRemoveBySubId($sub_category_id) {
    global $con;
    $query = $con->query("SELECT * FROM `removes` ");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
            $row["title"] = $row["title_ar"];
        }
        $data[] = $row;
    }
    return $data;
}

//get SubCatgeory Price
function subCategorySizePrice($id) {
    global $con;
    $query = $con->query(" SELECT * FROM `sub_categories_size_prices` WHERE `sub_category_id`='$id' LIMIT 1 ");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        return $sub_category_size_price = $row['sub_category_size_price'];
    }
    return 0;
}

//get SubCatgeory Price
function subCategorySizes($id) {
    global $con;
    $query = $con->query(" SELECT * FROM `sub_categories_size_prices` WHERE `sub_category_id`='$id'  ");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
            $row["sub_category_name"] = $row["sub_category_size_name_ar"];
        }
        $data[] = $row;
    }
    return $data;
}

//check if Session Set
function check_session_set() {

    if (!isset($_SESSION['one_user_id']) || $_SESSION['one_user_id'] == '') {
        $value = register_user_session();
    }
    return $_SESSION['one_user_id'];
}

//create User Session
function register_user_session() {
    global $con;
    $value = md5(rand());
    $query = $con->query("INSERT INTO `sessions`(`value`) VALUES ('$value')");
    if (!$query) {
        register_user_session();
    } else {
        $_SESSION['one_user_id'] = $con->insert_id;
        return $_SESSION['one_user_id'];
    }
}

//call SESSIION Register
check_session_set();

//add item to cart
function add_item_to_cart($sub_id, $notes, $price, $quantity, $removes, $additions, $size) {
    global $con;
    $total_price = $price * $quantity;
    $user_id = $_SESSION['one_user_id'];
    $date = date("Y-m-d");
    $query_insert = $con->query("INSERT INTO `cart`(`sub_category_id`, `price`,`note`, `quantity`, `client_id`, `remove_id`,`addition_id`,`cart_type`,`size_id`,`date`) 
                                                       VALUES ('$sub_id','$total_price','$notes','$quantity','$user_id','$removes','$additions','2','$size','$date')
                                   ");
    if ($query_insert) {
        return 1;
    } else {
        return 0;
    }
}

//count item In cart
function get_item_count() {
    global $con;
    $user_id = $_SESSION['one_user_id'];
    //  $query = $con->query("SELECT * FROM `cart_session` WHERE `user_id`='$user_id' AND `status`='0' ");
    $query = $con->query("SELECT * FROM `cart` WHERE `client_id`='$user_id' AND `status`='0' AND `cart_type`=2 ");
    $count = mysqli_num_rows($query);
    return $count;
}

function get_cart_total() {
    global $con;
    $user_id = $_SESSION['one_user_id'];
    //$query = $con->query("SELECT * FROM `cart_session` WHERE `user_id`='$user_id' AND `status`='0' ");
    $query = $con->query("SELECT * FROM `cart` WHERE `client_id`='$user_id' AND `status`='0' AND `cart_type`=2 ");

    $total = 0;
    while ($row = mysqli_fetch_assoc($query)) {
        $total += $row['price'];
    }

    return $total;
}

//get item of cart
function get_item_cart() {
    global $con;
    $user_id = $_SESSION['one_user_id'];
    // $query = $con->query("SELECT * FROM `cart_session` WHERE `user_id`='$user_id' AND `status`='0' ");
    $query = $con->query("SELECT * FROM `cart` WHERE `client_id`='$user_id' AND `status`='0' AND `cart_type`='2' ");

    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        $id = $row['sub_category_id'];
        $row['sub_category_name'] = subCatgeoryById($id)['sub_category_name'];
        $row['sub_category_image'] = subCatgeoryById($id)['sub_category_image'];
        $data[] = $row;
    }

    $setting = setting();
    $vat = $setting['vat']; //vat percentage
    $accept_order = $setting['accept_orders'];
    $discount = $setting['discount'] ? $setting['discount_percentage'] : 0; //disocunt percentage


    return array("data" => $data, "vat" => $vat, "discount" => $discount, "accept_order" => $accept_order);
}

//get rgions
function getRegions() {
    global $con;
    if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
        $query = $con->query("SELECT * FROM `regions` WHERE `display`='1' ORDER BY `region_name_ar` ASC");
    } else {
        $query = $con->query("SELECT * FROM `regions` WHERE `display`='1' ORDER BY `region_name_en` ASC");
    }
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
            $row["region_name_en"] = $row["region_name_ar"];
        }
        $data[] = $row;
    }
    return $data;
}

function get_region_data($id) {
    global $con;
    $query = $con->query("SELECT * FROM `regions` WHERE `region_id`='$id' ");
    $data = array();
    while ($row = mysqli_fetch_assoc($query)) {
        if (isset($_COOKIE['site_lang']) && $_COOKIE['site_lang'] == 'ar') {
            $row["region_name_en"] = $row["region_name_ar"];
        }
        $data = $row;
    }
    return $data;
}

//add user address
function add_user_address($name, $phone, $region_id, $buidling, $road, $block, $special_directions, $email, $order_type) {
    global $con;
    $user_id = $_SESSION['one_user_id'];
    $query = $con->query("INSERT INTO `user_addresses_session`(`region`, `block`, `road`, `building`, `name`, `phone`, `note`, `user_id`,`email`,`order_type`)
                                                     VALUES ('$region_id','$block','$road','$buidling','$name','$phone','$special_directions','$user_id','$email','$order_type')
                     ");
    return $con->insert_id ? : 0;
}
//get last user addresse
function get_user_address_by_user_id($user_id) {
    global $con;
    $query = $con->query("SELECT * FROM `user_addresses_session` WHERE `user_id`='$user_id' ORDER BY id DESC LIMIT 1 ");
    $row = mysqli_fetch_assoc($query);
    $row['region_name_en'] = get_region_data($row['region'])['region_name_en'];
    return $row ? : array();
}

//get last user addresse
function get_user_address() {
    global $con;
    $user_id = $_SESSION['one_user_id'];
    $query = $con->query("SELECT * FROM `user_addresses_session` WHERE `user_id`='$user_id' ORDER BY id DESC LIMIT 1 ");
    $row = mysqli_fetch_assoc($query);
    $row['region_name_en'] = get_region_data($row['region'])['region_name_en'];
    return $row ? : array();
}

function get_user_cart($user_id) {
    global $con;
    $query = $con->query("SELECT * FROM `cart` WHERE `client_id`='$user_id' AND `status`='0' AND `cart_type`='2' ");

    $data = array();
    $all_cart_ids = '';
    while ($row = mysqli_fetch_assoc($query)) {
        $id = $row['cart_id'];
        $all_cart_ids.=$id . ',';
    }
    $all_cart_ids = substr($all_cart_ids, 0, -1);
    return $all_cart_ids;
}

// make order
function make_order($payment) {
    global $con;
    $user_id = $_SESSION['one_user_id'];
    $table_id=$_SESSION['table_id'];
    
    
    $user_address_id = get_user_address()['id'];
    $region_id = get_user_address()['region']; //get region id to get fees of delivery
    $user_email = get_user_address()['email'];
    $order_type  = get_user_address()['order_type'];
    

    
    if($order_type ==  "Delivery"){
        $deliver_id = 1;
    }elseif($order_type ==  "TakeAway"){
        $deliver_id = 2;
    }elseif($order_type ==  "InRestaurant"){
        $deliver_id = 3;
    }

    $charge_cost = 0;
    $setting = setting(); //to get vat and discount

    $branch_id = $setting['branch_id'];

    if ($deliver_id !=1 ) {
        $user_address_id = 0;
    }else{
        $region_id = get_user_address($user_address_id)['region']; //get region id to get fees of delivery
        $charge_cost = get_region_data($region_id)["charge"]; //delivery Fees
    }



    $vat = $setting['vat']; //vat percentage
    $discount = $setting['discount'] ? $setting['discount_percentage'] : 0; //disocunt percentage
    $cart = get_item_cart()['data'];
    $cart_ids = "";

    foreach ($cart as $key => $row) {
        $id = $row['cart_id']; //cart_id
        $cart_ids .= $id . ",";
//            $query_update_cart = $con->query("UPDATE `cart_session` SET `status`=1 WHERE `id`='$id'");
        $query_update_cart = $con->query("UPDATE `cart` SET `status`=1 WHERE `cart_id`='$id'");

        $sub_catgeory_id = $row['sub_catgeory_id'];
        $sub_category_name = $row['sub_category_name'];
        $price = $row['price'];
        $notes = $row['notes'];
        $quantity = $row['quantity'];
        $status = $row['status'];
        $user_id = $row['client_id'];
        $date_added = $row['date_added'];
        $total_price = $row['price'];
        $sum_total += number_format($total_price, 3, '.', '');
    }
    $discount_value = number_format($discount / 100 * $sum_total, '3', '.', '');
    
    $total_amount_after_disc = $sum_total - $discount_value;
    $vat_value = ( $total_amount_after_disc * 90/100 )*($vat/100);

    $sub_total =  number_format(($sum_total), 3, '.', '');
    $sum_total = number_format(($total_amount_after_disc  + $charge_cost), 3, '.', '');
    $order_status = 0;
    $order_follow = 0;

    $payment="Cash";
    // if(isset($_POST['payment'])){
    //     $payment=$_POST['payment'];
    // }else{
    //     $payment="Cash";
    // }

    $date_time = date("Y-m-d H:i:s");

    $query_insert_order = $con->query("INSERT INTO `orders`(`branch_id`,`cart_id`, `client_id`, `client_address_id`, `total_price`,`vat`,`vat_percentage`,`charge_cost`, `discount_percentage`, `net_price`, `order_status`, `order_follow`, `payment`, `mobile_type` ,`deliver_id`, `date`)
                                                        VALUES ('$branch_id','$cart_ids','$user_id','$user_address_id','$sub_total','$vat_value','$vat','$charge_cost','$discount','$sum_total','$order_status','$order_follow','$payment','Web','$deliver_id','$date_time')
                                        ");

    $order_id = $con->insert_id;
    if ($order_id) {

        //$to = "";
        $subject = "Al Dahiya Restaurant Website - New Order";
        $headers = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
        $headers .="From: Al Dahiya Restaurant Website" . " Info@emcan-group.com\r\n" . "Reply-To:Info@emcan-group.com\r\n";
        $message = send_email($order_id);
        mail($to, $subject, $message, $headers);

        $to = "apps@emcan-group.com";
        $subject = "Al Dahiya Restaurant Website - New Order";
        $headers = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
        $headers .="From: Al Dahiya Restaurant Website" . " Info@emcan-group.com\r\n" . "Reply-To:Info@emcan-group.com\r\n";
        $message = send_email($order_id);
        mail($to, $subject, $message, $headers);


        $to = $user_email;
        $subject = "Al Dahiya Restaurant Website - New Order";
        $headers = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=utf-8' . "\r\n";
        $headers .="From: Al Dahiya Restaurant Website" . " Info@emcan-group.com\r\n" . "Reply-To:Info@emcan-group.com\r\n";
        $message = send_email($order_id);
        mail($to, $subject, $message, $headers);

    }

    return $order_id ? : 0;


    return $con->insert_id ? : 0;
}

function send_email($order_id) {
    global $con;
    $logo = mainData()['image'];
    $query_select = $con->query("SELECT * FROM `orders` WHERE `order_id`='" . $order_id . "' LIMIT 1 ");
    $row_select = mysqli_fetch_assoc($query_select);

    $cart_id = $row_select['cart_id'];

    $order_id = $row_select['order_id'];
    $payment = $row_select['payment'];
    $payment_name=paymentMethodDataById($payment)['name_en'];
    $client_id = $row_select['client_id'];
    $client_address_id = $row_select['client_address_id'];
    $charge_cost = number_format($row_select['charge_cost'], 3, '.', '');
    $total_price = number_format($row_select['total_price'], 3, '.', '');
    $net_price = number_format($row_select['net_price'], 3, '.', '');

    $discount_percentage_number = $row_select['discount_percentage'];

    $discount_percentage = number_format($row_select['discount_percentage'], 3, '.', '');

    $discount_value = strval(($discount_percentage_number / 100) * $total_price);

    $total_after_discount = $row_select['total_price'] - $discount_value;

    $vat = number_format($row_select['vat'], 3, '.', '');

    $message = '
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
        "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <title>Automatic Email</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
</head>
<body style="margin:0; padding:10px 0 0 0;" bgcolor="#FFFFFF">

<table align="center" cellpadding="0" cellspacing="0" width="95%%" style="padding:15px;">
    <tr>
        <td align="center">
            <table align="center" border="1" cellpadding="0" cellspacing="0" width="600px" style="margin:15px;padding:15px;border-collapse: separate; border-spacing: 5px 5px; #000;" bgcolor="#FFFFFF">
                <tr>
                    <td align="center" style="padding:5px;">
                        <a href="http://aldahiyabh.com/" target="_blank">
                            <img src="' . $logo . '" alt="Logo" style="width:186px;border:0;"/>
                        </a>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#ffffff" style="padding:30px 0;">
                        <table cellpadding="0" cellspacing="0" width="100%" style="margin-bottom:15px;text-align:left;direction:ltr;">
                            <tr>
                                <td style="padding:0; font-family: Avenir, sans-serif; font-size: 16px;">
                                    <!-- Initial text goes here-->
                                    <h2 style="text-align:center;color:#31A4F1;font-family:tahoma;"> Summary Order From Al Dahiya Restaurant Website </h2>

                                  <br/>
                                  <table style="border:1px solid #eee;padding: 5px;width: 100%;text-align: center;margin-bottom: 30px;" class="table table-striped">
	                                  <thead>
                                            <th style="width: 40%;font-size: 14px;font-weight: bold;font-family: tahoma;"> Item </th>
                                            <th style="width: 40%;font-size: 14px;font-weight: bold;font-family: tahoma;">Quantity</th>
                                            <th style="width: 20%;font-size: 14px;font-weight: bold;font-family: tahoma;">Total</th>
	                                 </thead>
	                                  <tbody>';


    $client_addresses_row_select = get_user_address_by_user_id($client_id);
    $cart_id_all = explode(',', $cart_id);

    $key = 0;
    $count = count($cart_id_all);

    while ($count > $key) {

        $one = $cart_id_all[$key];
        $key++;


        $cart = $con->query("SELECT * FROM `cart` WHERE `cart_id`='$one'");
        $row_select = mysqli_fetch_assoc($cart);
        $sub_category_id = $row_select['sub_category_id'];
        $quantity = $row_select['quantity'];
        $price = $row_select['price'];

        if (!$one || empty($one) || $one = '') {
            continue;
        }

        $query_select_two = $con->query("SELECT * FROM `sub_categories` WHERE `sub_category_id`='" . $sub_category_id . "'  LIMIT 1 ");
        $row_select_two = mysqli_fetch_assoc($query_select_two);
        $sub_category_name = $row_select_two['sub_category_name'];

        $message .= '<tr style="border: 1px solid black;">';
        $message .= '<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $sub_category_name . '</td>';
        $message .= '<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $quantity . '</td>';
        $message .= '<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $price . ' BD</td>';
        $message .= '</tr>';
    }

    $message .= '</tbody></table>
                          
                                  <table style="border:1px solid #eee;padding: 5px;width: 100%%; text-align: center;margin-bottom: 30px;" class="table table-striped">
	                                  <thead>
	                                	  <th style="width: 15%;font-size: 14px;font-weight: bold;font-family: tahoma;"> # </th>
	                                	  <th style="width: 15%;font-size: 14px;font-weight: bold;font-family: tahoma;">  Recieve Way  </th>
	                                	  
	                                	  <th style="width: 20%;font-size: 14px;font-weight: bold;font-family: tahoma;"> Client Name </th>
	                                	  <th style="width: 20%;font-size: 14px;font-weight: bold;font-family: tahoma;"> Phone </th>
	                                	  <th style="width: 15%;font-size: 14px;font-weight: bold;font-family: tahoma;">Region </th>
	                                	  <th style="width: 10%;font-size: 14px;font-weight: bold;font-family: tahoma;">Block</th>
	                                	  <th style="width: 10%;font-size: 14px;font-weight: bold;font-family: tahoma;">Road</th>
	                                	  <th style="width: 10%;font-size: 14px;font-weight: bold;font-family: tahoma;">Building</th>
	                                	  <th style="width: 10%;font-size: 14px;font-weight: bold;font-family: tahoma;">Flat</th>
	                                	  <th style="width: 15%;font-size: 14px;font-weight: bold;font-family: tahoma;">Notes</th>
	                                  </thead>
	                                  <tbody>
	                                  	<tr style="border: 1px solid black;">
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $order_id . '</td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;"> ' . $client_addresses_row_select['order_type'] . '</td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;"> ' . $client_addresses_row_select['name'] . '</td>
	                                  		
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $client_addresses_row_select['phone'] . '</td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $client_addresses_row_select['region_name_en'] . '</td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $client_addresses_row_select['block'] . '</td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $client_addresses_row_select['road'] . '</td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;"> ' . $client_addresses_row_select['building'] . '</td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;"> ' . $client_addresses_row_select['flat_number'] . '</td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $client_addresses_row_select['note'] . '</td>
	                                  	</tr>     
	                                  </tbody>
                                  </table>                                  

                                  <table style="border:1px solid #eee;padding: 5px;width: 100%%; text-align: center;margin-bottom: 30px;" class="table table-striped">
	                                  <thead>
	                                	  <th colspan="2" style="width: 15%;font-size: 14px;font-weight: bold;font-family: tahoma;">Sub Total</th>
	                                	  <th style="width: 15%;font-size: 14px;font-weight: bold;font-family: tahoma;">Discount </th>
	                                	  <th style="width: 15%;font-size: 14px;font-weight: bold;font-family: tahoma;"> Price After Discount </th>
	                                	  <th style="width: 20%;font-size: 14px;font-weight: bold;font-family: tahoma;"> VAT </th>
	                                	  <th style="width: 20%;font-size: 14px;font-weight: bold;font-family: tahoma;"> Delivery Charge </th>
	                                	  <th style="width: 20%;font-size: 14px;font-weight: bold;font-family: tahoma;">   Payment Method </th>
	                                	  <th colspan="2" style="width: 15%;font-size: 14px;font-weight: bold;font-family: tahoma;">Total</th>
	                                  </thead>
	                                  <tbody>
	                                  	<tr style="border: 1px solid black;">
	                                  		<td colspan="2" style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . number_format((float) ( ( $total_price )), 3, '.', '') . ' BD </td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $discount_percentage_number . '  %</td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . number_format((float) ( ( $total_after_discount )), 3, '.', '') . '  BD </td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . number_format((float) ( (($vat ))), 3, '.', '') . ' BD </td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . number_format((float) ( ( $charge_cost)), 3, '.', '') . ' BD </td>
	                                  		<td style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . $payment_name . '  </td>
	                                  		<td colspan="2" style="font-size: 12px;padding-top: 10px;border-top: 1px solid #000;">' . number_format((float) ( ( $net_price )), 3, '.', '') . ' BD </td>
	                                  	</tr>     
	                                  </tbody>
                                  </table>
                                
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
          
                <tr>
                    <td bgcolor="#FFFFFF">
                        <table cellpadding="0" cellspacing="0" width="100%%" style="padding:10px;">
                            <tr>
                                <td width="260" valign="top" style="padding: 0 0 15px 0;">
                                    <table cellpadding="0" cellspacing="0" width="100%%">
                                        <tr>
                                            <td align="center">
                                                <a href="#" target="_blank">
                                                    <img src="http://aldahiyabh.com/system/api/phone-icon.jpeg" alt="اتصل بنا"
                                                         style="display: block;"/>
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td align="center"
                                                style="font-family: tahoma; font-weight:bold; color:#707070;font-size: 13px;padding: 10px 0 0 0;">
                                                اتصل بنا
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td style="font-size: 0; line-height: 0;" width="20">
                                    &nbsp;
                                </td>
                                <td width="260" valign="top">
                                    <table cellpadding="0" cellspacing="0" width="100%%" >
                                        <tr>
                                            <td align="center">
                                                <a href="#">
                                                    <img src="http://aldahiyabh.com/system/api/email-icon.jpeg" alt="Email us"
                                                         style="display: block;"/>
                                                </a>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td align="center"
                                                style="font-family: tahoma; font-weight:bold; color:#707070;font-size: 13px;padding: 10px 0 0 0;">
                                                راسنا على البريد الإلكتروني
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                                <td style="font-size: 0; line-height: 0;" width="20">
                                    &nbsp;
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td bgcolor="#FFFFFF" style="padding: 15px 15px 15px 15px;">
                        <table cellpadding="0" cellspacing="0" width="100%%">
                            <tr>
                                <td align="center">
                                    <table cellpadding="0" cellspacing="0">
                                        <tr>
                                            <td>
                                                <a href="#" target="_blank">
                                                    <img src="http://aldahiyabh.com/system/api/facebook-icon.jpeg" alt="Facebook" width="50" height="50" style="display: block;"/>
                                                </a>
                                            </td>
                                            <td style="font-size: 0; line-height: 0;" width="20">&nbsp;</td>
                                            <td>
                                                <a href="#" target="_blank">
                                                    <img src="http://aldahiyabh.com/system/api/instagram-icon.jpeg" alt="Instagram" width="50" height="50"style="display: block;"/>
                                                </a>
                                            </td>
                                            <td style="font-size: 0; line-height: 0;" width="20">&nbsp;</td>
                                            <td>
                                                <a href="#" target="_blank">
                                                    <img src="http://aldahiyabh.com/system/api/twitter-icon.jpeg" alt="Twitter" width="50" height="50"style="display: block;"/>
                                                </a>
                                            </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
        </td>
    </tr>
</table>
</body>
</html>';


    return $message;
}
?>