<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection = $con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

header('Content-Type: application/json');


// get all products from products table

if (isset($_GET['lang']) && $_GET['lang'] != '') {

    $lang = $_GET['lang'];


if($lang == "ar") {

    $result = $connection->query("SELECT * FROM `regions` where `display`=1 ORDER BY `region_name_ar` ASC")  or die(mysqli_error($connection));

} else {

$result = $connection->query("SELECT * FROM `regions` where `display`=1 ORDER BY `region_name_en` ASC")  or die(mysqli_error($connection));

}


// check for empty result
    if (mysqli_num_rows($result) > 0) {
        // looping through all results
        // products node
        $response["product"] = array();

        while ($row = mysqli_fetch_array($result)) {
            // temp client array
            $product = array();
            $product["region_id"] = $row["region_id"];
            if ($lang == "ar") {
                $product["region_name"] = $row["region_name_ar"];
            } else {
                $product["region_name"] = $row["region_name_en"];
            }
            $product["city_id"] = $row["city_id"];
            $product["charge"] = $row["charge"];
            $product["min_order"] = $row["min_order"];
            $product["order_period"] = $row["order_period"];

            // push single product into final response array
            array_push($response["product"], $product);
        }
        // success
        $response["success"] = 1;


        // echoing JSON response
        echo json_encode($response);
    } else {

        // no products found
        $response["success"] = 0;
        if ($lang == "ar") {
            $response["message"] = "لا يوجد احياء";
        } else {
            $response["message"] = "There is no regions";
        }
        // echo no clients JSON
        echo json_encode($response);
    }
} else {
    // no products found
    $response["success"] = 0;
    $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";
    
    // echo no users JSON
    echo json_encode($response);
}
?>