<?php

/*
 * Following code will list all the products
 */
// array for JSON response
$response = array();

// include db connect class
include("db_connect.php");

// connecting to db
$con = new DB_CONNECT();
$connection = $con->connect();

$connection->query("SET NAMES 'utf8'");

$connection->query("SET CHARACTER SET utf8");

$connection->query("SET SESSION collation_connection = 'utf8_unicode_ci'");

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET,POST,PUT,DELETE,OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With');

header('Content-Type: application/json');


// get all products from products table

if (isset($_GET['sub_category_id']) && $_GET['lang'] != '') {

    $lang = $_GET['lang'];
    $sub_category_id = $_GET['sub_category_id'];
    $sub_category_data = get_sub_category_data_by_id($sub_category_id);

    $result = $connection->query("SELECT * FROM `sub_categories_size_prices` WHERE `sub_category_id`='$sub_category_id' and `display`=1 ") or die(mysqli_error($connection));

// check for empty result
    if (mysqli_num_rows($result) > 0) {
        // looping through all results
        // products node
        $response["product"] = array();

        while ($row = mysqli_fetch_array($result)) {
            // temp user array
            $product = array();
            $product["sub_category_size_price_id"] = $row["sub_category_size_price_id"];
            if ($lang == "ar") {
                $product["sub_category_size_name"] = $row["sub_category_size_name_ar"];
            } else {
                $product["sub_category_size_name"] = $row["sub_category_size_name"];
            }

            $sub_category_size_price = $row["sub_category_size_price"];

            if (checkValidOffer($sub_category_id) >= 1) {
                $product["discount"] = $discount = $sub_category_data['discount'];
                $discount_type = $sub_category_data['discount_type'];

                if ($discount_type == 1) {

                    $discount_percentage = $sub_category_data['discount_percentage'];

                    $price_after = $sub_category_size_price - (($discount_percentage / 100) * $sub_category_size_price);
                } else {
                    $fixed_price = $sub_category_data['discount_percentage'];

                    $price_after = $fixed_price;
                }
            } else {
                $product["discount"] = "0";
                $price_after = $sub_category_size_price;
            }


            $product["sub_category_size_price_after_disc"] = number_format((float) ($price_after), 3, '.', '');
            $product["sub_category_size_price"] = number_format((float) ( $sub_category_size_price ), 3, '.', '');

            // push single product into final response array
            array_push($response["product"], $product);
        }
        // success
        $response["success"] = 1;


        // echoing JSON response
        echo json_encode($response);
    } else {

        $response["product"] = array();

        // temp user array
        $product = array();

        // success
        $response["success"] = 1;

        // echoing JSON response
        echo json_encode($response);
    }
} else {
    // no products found
    $response["success"] = 0;
    if ($lang == "ar") {
        $response["message"] = "هناك بيانات مفقوده برجاء مراجعة بياناتك";
    } else {
        $response["message"] = "Missing data Please review your data";
    }
    // echo no users JSON
    echo json_encode($response);
}
?>